"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirQuantity", {
    enumerable: true,
    get: function() {
        return FhirQuantity;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirQuantity = class FhirQuantity extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            value: _yup.number().nullable().default(null),
            unit: _yup.string().nullable().default(null),
            system: _yup.string().nullable().default(null),
            code: _yup.string().nullable().default(null)
        }).noUnknown();
    }
    static fake() {
        return new this({
            value: (0, _lodash.random)(1, 100),
            unit: 'g'
        });
    }
};

//# sourceMappingURL=quantity.js.map