"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    showError: function() {
        return showError;
    },
    withErrorShown: function() {
        return withErrorShown;
    }
});
function withErrorShown(fn) {
    return ()=>showError(fn);
}
async function showError(fn) {
    try {
        return await (typeof fn === 'function' ? fn() : fn);
    } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        throw err;
    }
}

//# sourceMappingURL=errors.js.map