"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    certificateCommand: function() {
        return certificateCommand;
    },
    generateCertificate: function() {
        return generateCertificate;
    }
});
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("../database");
const _makePatientCertificate = require("../utils/makePatientCertificate");
const generateCertificate = async ({ patientId })=>{
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const { Patient } = store.models;
    try {
        const patient = await Patient.findByPk(patientId);
        _logging.log.info(`Generating vaccine certificate for patient id "${patientId}"`);
        const pdf = await (0, _makePatientCertificate.makeVaccineCertificate)({
            patient,
            printedBy: 'Admin',
            printedDate: null,
            models: store.models
        });
        _logging.log.info(`Certificate output: `, pdf);
    } catch (error) {
        process.stderr.write(`Report failed: ${error.stack}\n`);
        process.exit(1);
    }
    process.exit(0);
};
const certificateCommand = new _commander.Command('generateVaccineCertificate').requiredOption('-p, --patientId <string>').action(generateCertificate);

//# sourceMappingURL=generateVaccineCertificate.js.map