"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "OutpatientDischarger", {
    enumerable: true,
    get: function() {
        return OutpatientDischarger;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _utils = require("@tamanu/shared/utils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let OutpatientDischarger = class OutpatientDischarger extends _tasks.ScheduledTask {
    getName() {
        return 'OutpatientDischarger';
    }
    async countQueue() {
        const where = (0, _utils.getDischargeOutPatientEncountersWhereClause)();
        return this.models.Encounter.count({
            where
        });
    }
    async run() {
        const { batchSize, batchSleepAsyncDurationInMilliseconds } = _config.default.schedules.outpatientDischarger;
        await (0, _utils.dischargeOutpatientEncounters)(this.models, null, batchSize, batchSleepAsyncDurationInMilliseconds);
    }
    constructor(context, overrideConfig = null){
        const conf = {
            ..._config.default.schedules.outpatientDischarger,
            ...overrideConfig
        };
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.config = conf;
        this.models = context.store.models;
        // run once on startup (in case the server was down when it was scheduled)
        if (!conf.suppressInitialRun) {
            this.runImmediately();
        }
    }
};

//# sourceMappingURL=OutpatientDischarger.js.map