"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('certifiable_vaccines', {
        id: {
            type: _sequelize.STRING,
            defaultValue: _sequelize.UUIDV4,
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.DATE,
            defaultValue: _sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DATE,
            defaultValue: _sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DATE,
            allowNull: true
        },
        vaccine_id: {
            type: _sequelize.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        manufacturer_id: {
            type: _sequelize.STRING,
            allowNull: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        icd11_drug_code: {
            type: _sequelize.STRING,
            allowNull: false
        },
        icd11_disease_code: {
            type: _sequelize.STRING,
            allowNull: false
        },
        atc_code: {
            type: _sequelize.STRING,
            allowNull: false
        },
        target_snomed_code: {
            type: _sequelize.STRING,
            allowNull: true
        },
        eu_product_code: {
            type: _sequelize.STRING,
            allowNull: true
        },
        maximum_dosage: {
            type: _sequelize.INTEGER,
            allowNull: false,
            defaultValue: 1
        }
    });
    await query.addConstraint('certifiable_vaccines', {
        type: 'unique',
        name: 'certifiable_vaccines_unique_vaccine_id',
        fields: [
            'vaccine_id'
        ]
    });
}
async function down(query) {
    await query.removeConstraint('certifiable_vaccines', 'certifiable_vaccines_unique_vaccine_id');
    await query.dropTable('certifiable_vaccines');
}

//# sourceMappingURL=076_addCertifiableVaccinesTable.js.map