"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const COMMON_COLUMNS = {
    id: {
        type: _sequelize.default.STRING,
        defaultValue: _sequelize.default.UUIDV4,
        allowNull: false,
        primaryKey: true
    },
    created_at: {
        type: _sequelize.default.DATE,
        defaultValue: _sequelize.default.NOW
    },
    updated_at: {
        type: _sequelize.default.DATE,
        defaultValue: _sequelize.default.NOW
    },
    deleted_at: {
        type: _sequelize.default.DATE,
        defaultValue: _sequelize.default.NOW
    }
};
const _default = {
    up: async (query)=>{
        await query.dropTable('settings');
        await query.createTable('settings', {
            ...COMMON_COLUMNS,
            key: {
                type: _sequelize.default.STRING,
                allowNull: false
            },
            value: {
                type: _sequelize.default.STRING,
                allowNull: true
            },
            facility_id: {
                type: _sequelize.default.STRING,
                references: {
                    model: 'facilities',
                    key: 'id'
                },
                allowNull: true
            }
        });
    },
    down: async (query)=>{
        await query.dropTable('settings');
        await query.createTable('settings', {
            ...COMMON_COLUMNS,
            settingName: {
                type: _sequelize.default.STRING,
                unique: true
            },
            settingContent: _sequelize.default.STRING
        });
    }
};

//# sourceMappingURL=127_setupNewSettingsTable.js.map