"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // for the next migration, that expects only one PAD per patient, we hard delete any soft deleted
    // records as only the "live" record should be kept, and even if there is no duplicate currently,
    // having a soft deleted record for a patient would prevent recording any PAD against them
    await query.bulkDelete('patient_additional_data', {
        deleted_at: {
            [_sequelize.Op.not]: null
        }
    }); // this bit destructive, can't be downed
}
async function down() {
// no way to get the data back
}

//# sourceMappingURL=130_hardDeleteSoftDeletedPADs.js.map