"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceInsurancePlan", {
    enumerable: true,
    get: function() {
        return InvoiceInsurancePlan;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
let InvoiceInsurancePlan = class InvoiceInsurancePlan extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            defaultCoverage: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.hasMany(models.InvoiceInsurancePlanItem, {
            foreignKey: 'invoiceInsurancePlanId',
            as: 'invoiceInsurancePlanItems'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=InvoiceInsurancePlan.js.map