"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProcedureAssistantClinician", {
    enumerable: true,
    get: function() {
        return ProcedureAssistantClinician;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sync = require("../sync");
let ProcedureAssistantClinician = class ProcedureAssistantClinician extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Procedure, {
            foreignKey: 'procedureId',
            as: 'procedure'
        });
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'procedures',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _sync.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _sync.buildEncounterLinkedLookupJoins)(this, [
                'procedures',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=ProcedureAssistantClinician.js.map