"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchParameters", {
    enumerable: true,
    get: function() {
        return searchParameters;
    }
});
const _constants = require("@tamanu/constants");
const searchParameters = {
    patient: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'patient'
            ]
        ],
        referenceTypes: [
            'Patient'
        ]
    },
    'vaccine-code': {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'vaccineCode',
                'coding',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.CODING
    }
};

//# sourceMappingURL=searchParameters.js.map