import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import { REPEAT_FREQUENCY } from '@tamanu/constants';
export declare class LocationAssignmentTemplate extends Model {
    id: string;
    userId: string;
    locationId: string;
    date: string;
    startTime: string;
    endTime: string;
    repeatEndDate: string;
    repeatFrequency: number;
    repeatUnit: keyof typeof REPEAT_FREQUENCY;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): string;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    /**
     * Generate repeating location assignments
     */
    generateRepeatingLocationAssignments(): Promise<void>;
}
//# sourceMappingURL=LocationAssignmentTemplate.d.ts.map