import { WELL_KNOWN_PROBLEM_KEYS } from './constants';
export class BaseError extends Error {
    name;
    type;
    title;
    status;
    detail;
    extraData = {};
    constructor(type, title, status, detail) {
        super(detail ?? title);
        this.name = this.constructor.name;
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
    }
    withCause(error) {
        this.cause = error;
        return this;
    }
    withExtraData(extraData) {
        if (Object.keys(extraData).some(key => [...WELL_KNOWN_PROBLEM_KEYS, 'stack'].includes(key))) {
            throw new Error('BUG: reserved extra data key');
        }
        Object.assign(this.extraData, extraData);
        return this;
    }
}
