"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const Sequelize = require('sequelize');
const Utils = require('sequelize/lib/utils');
// ===
// some utility functions that mean I can just copypaste model
// definitions over rather than changing table and field names by hand
const underscoreObject = (obj)=>{
    const translated = {};
    Object.keys(obj).forEach((k)=>{
        translated[Utils.underscore(k)] = obj[k];
    });
    return translated;
};
const makeTableName = (name)=>{
    if (name.toLowerCase() === 'referencedata') return 'reference_data';
    const underscored = Utils.pluralize(Utils.underscore(name));
    return underscored.replace(/^_/, '');
};
const foreignKey = (table)=>({
        type: Sequelize.STRING,
        references: {
            model: makeTableName(table),
            key: 'id'
        }
    });
const BASE_FIELDS = {
    id: {
        type: Sequelize.STRING,
        defaultValue: Sequelize.UUIDV4,
        allowNull: false,
        primaryKey: true
    },
    createdAt: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
    updatedAt: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
    deletedAt: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    }
};
// =/=
const modelsPromises = [
    'referenceData',
    'user',
    'patient',
    'patientAllergy',
    'patientCarePlan',
    'patientCondition',
    'patientFamilyHistory',
    'patientIssue',
    'encounter',
    'encounterDiagnosis',
    'encounterMedication',
    'procedure',
    'vitals',
    'triage',
    'referral',
    'referralDiagnosis',
    'scheduledVaccine',
    'administeredVaccine',
    'program',
    'programDataElement',
    'survey',
    'surveyScreenComponent',
    'surveyResponse',
    'surveyResponseAnswer',
    'labRequest',
    'labTestType',
    'labTest',
    'imagingRequest',
    'reportRequest',
    'patientCommunication',
    'setting',
    'syncMetadata',
    'note'
].map(async (k)=>{
    // eslint-disable-next-line global-require
    const module = await Promise.resolve(`./000_initial/${k}`).then((p)=>/*#__PURE__*/ _interop_require_wildcard(require(p))).then((m)=>m.default);
    const { fields, options } = module({
        Sequelize,
        foreignKey
    });
    return {
        name: makeTableName(k),
        fields: {
            ...underscoreObject(BASE_FIELDS),
            ...underscoreObject(fields)
        },
        options
    };
});
const _default = {
    up: async (query)=>{
        await query.sequelize.transaction(async (transaction)=>{
            const models = await Promise.all(modelsPromises);
            for (const t of (await Promise.all(models))){
                await query.createTable(t.name, t.fields, t.options, {
                    transaction
                });
            }
        });
    },
    down: async (query)=>{
        await query.sequelize.transaction(async (transaction)=>{
            const models = await Promise.all(modelsPromises);
            const reversed = [
                ...models
            ].reverse();
            for (const t of reversed){
                await query.dropTable(t.name, {
                    transaction
                });
            }
        });
    }
};

//# sourceMappingURL=000_initial.js.map