"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Given that the foreign key constraint is already added,
    // no need to put references in here. In some Sequelize versions
    // it breaks, in others it creates a duplicate foreign key.
    await query.changeColumn('discharges', 'discharger_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
}
async function down(query) {
    await query.bulkDelete('discharges', {
        discharger_id: null
    });
    await query.changeColumn('discharges', 'discharger_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false
    });
}

//# sourceMappingURL=1678918010271-removeNotNullConstraintFromDischarges.js.map