"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    tableName: 'debug_logs',
    schema: 'logs'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        info: {
            type: _sequelize.DataTypes.JSON,
            allowNull: false
        }
    });
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1723695765182-addDebugLogsTable.js.map