"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncLookup", {
    enumerable: true,
    get: function() {
        return SyncLookup;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let SyncLookup = class SyncLookup extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            recordId: {
                type: _sequelize.DataTypes.STRING
            },
            recordType: {
                type: _sequelize.DataTypes.STRING
            },
            data: {
                type: _sequelize.DataTypes.JSON
            },
            updatedAtSyncTick: {
                type: _sequelize.DataTypes.BIGINT
            },
            patientId: {
                type: _sequelize.DataTypes.STRING
            },
            encounterId: {
                type: _sequelize.DataTypes.STRING
            },
            facilityId: {
                type: _sequelize.DataTypes.STRING
            },
            isLabRequest: {
                type: _sequelize.DataTypes.BOOLEAN
            },
            isDeleted: {
                type: _sequelize.DataTypes.BOOLEAN
            },
            updatedAtByFieldSum: {
                type: _sequelize.DataTypes.BIGINT
            },
            pushedByDeviceId: {
                type: _sequelize.DataTypes.TEXT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            tableName: 'sync_lookup',
            timestamps: false
        });
    }
};

//# sourceMappingURL=SyncLookup.js.map