"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "reports", {
    enumerable: true,
    get: function() {
        return reports;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _reports = /*#__PURE__*/ _interop_require_wildcard(require("@tamanu/shared/reports"));
const _checkReportModulePermissions = require("@tamanu/shared/reports/utilities/checkReportModulePermissions");
const _createNamedLogger = require("@tamanu/shared/services/logging/createNamedLogger");
const _getAvailableReports = require("@tamanu/shared/reports/utilities/getAvailableReports");
const _errors = require("@tamanu/errors");
const _assertReportEnabled = require("../../utils/assertReportEnabled");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const FACILITY_REPORT_LOG_NAME = 'FacilityReport';
const reports = _express.default.Router();
reports.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked(); // check happens in getAvailableReports
    const { models, user, ability } = req;
    const availableReports = await (0, _getAvailableReports.getAvailableReports)(ability, models, user.id);
    res.send(availableReports);
}));
reports.post('/:reportId', (0, _expressasynchandler.default)(async (req, res)=>{
    const { body: { parameters = {}, facilityId }, user, params, db, getLocalisation, models, reportSchemaStores } = req;
    const { reportId } = params;
    const facilityReportLog = (0, _createNamedLogger.createNamedLogger)(FACILITY_REPORT_LOG_NAME, {
        userId: user.id,
        reportId
    });
    const localisation = await getLocalisation();
    (0, _assertReportEnabled.assertReportEnabled)(localisation, reportId);
    const reportModule = await _reports.getReportModule(reportId, models);
    if (!reportModule) {
        throw new _errors.NotFoundError('Report module not found');
    }
    await (0, _checkReportModulePermissions.checkReportModulePermissions)(req, reportModule, reportId, parameters);
    try {
        facilityReportLog.info('Running report', {
            parameters
        });
        const excelData = await reportModule.dataGenerator({
            models,
            reportSchemaStores,
            sequelize: db,
            facilityId
        }, parameters);
        facilityReportLog.info('Report run successfully');
        res.send(excelData);
    } catch (e) {
        facilityReportLog.error('Report module failed to generate data', {
            stack: e.stack
        });
        res.status(400).send({
            error: {
                message: e.message
            }
        });
    }
}));

//# sourceMappingURL=reports.js.map