"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    GENERIC_SURVEY_EXPORT_REPORT_ID: function() {
        return _reportDefinitions.GENERIC_SURVEY_EXPORT_REPORT_ID;
    },
    REPORT_DEFINITIONS: function() {
        return _reportDefinitions.REPORT_DEFINITIONS;
    },
    REPORT_OBJECTS: function() {
        return _reportObjects.REPORT_OBJECTS;
    },
    getReportModule: function() {
        return getReportModule;
    }
});
const _genericsurveyexportlinelist = /*#__PURE__*/ _interop_require_wildcard(require("./generic-survey-export-line-list"));
const _reportDefinitions = require("./reportDefinitions");
const _reportObjects = require("./reportObjects");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function getReportModule(reportId, models) {
    const dbDefinedReportModule = await models.ReportDefinitionVersion.findByPk(reportId);
    if (dbDefinedReportModule) {
        return dbDefinedReportModule;
    }
    if (reportId === 'generic-survey-export-line-list') {
        return _genericsurveyexportlinelist;
    }
    return null;
}

//# sourceMappingURL=index.js.map