"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getPatientAdditionalData", {
    enumerable: true,
    get: function() {
        return getPatientAdditionalData;
    }
});
const _getPatientSurveyResponseAnswer = require("./getPatientSurveyResponseAnswer");
async function getPatientAdditionalData(models, patientId, settings, fieldName) {
    const { PatientAdditionalData } = models;
    const patientAdditionalData = await PatientAdditionalData.findOne({
        where: {
            patientId
        },
        include: PatientAdditionalData.getFullReferenceAssociations()
    });
    const value = patientAdditionalData?.dataValues[fieldName];
    if (value) {
        return value;
    }
    const questionId = await settings.get(`questionCodeIds.${fieldName}`);
    return (0, _getPatientSurveyResponseAnswer.getPatientSurveyResponseAnswer)(models, patientId, questionId);
}

//# sourceMappingURL=getPatientAdditionalData.js.map