"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "HandoverPatient", {
    enumerable: true,
    get: function() {
        return HandoverPatient;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _getDisplayDate = require("../patientCertificates/getDisplayDate");
const _languageContext = require("../pdf/languageContext");
const _Divider = require("./Divider");
const _Layout = require("../patientCertificates/Layout");
const _Typography = require("../patientCertificates/Typography");
const _patientAccessors = require("../patientAccessors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PATIENT_FIELDS = [
    {
        key: 'name',
        label: 'Patient Name',
        accessor: _patientAccessors.getName,
        percentageWidth: 40
    },
    {
        key: 'displayId',
        label: 'Patient ID',
        percentageWidth: 40
    },
    {
        key: 'dateOfBirth',
        label: 'DOB',
        accessor: _patientAccessors.getDob,
        percentageWidth: 20
    },
    {
        key: 'sex',
        label: 'Sex',
        accessor: _patientAccessors.getSex,
        percentageWidth: 40
    }
];
const ValueDisplay = ({ width, title, value })=>/*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            width
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 5,
        style: {
            fontSize: 10
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: {
            fontSize: 10
        },
        bold: true
    }, title, ":"), ' ', value));
const HandoverPatient = ({ patient, location, arrivalDate, diagnosis, notes, getLocalisation, getSetting, createdAt, isEdited })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const detailsToDisplay = PATIENT_FIELDS.filter(({ key })=>!getSetting(`fields.${key}.hidden`));
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, {
        style: {
            width: '100%',
            marginBottom: 40
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            width: '100%'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor, percentageWidth = 33 })=>{
        const value = (accessor ? accessor(patient, {
            getLocalisation,
            getTranslation
        }) : patient[key]) || '';
        const label = defaultLabel || getTranslation(`general.localisedField.${key}.label.short`) || getTranslation(`general.localisedField.${key}.label`);
        return /*#__PURE__*/ _react.default.createElement(ValueDisplay, {
            key: key,
            width: `${percentageWidth}%`,
            title: label,
            value: value
        });
    }), /*#__PURE__*/ _react.default.createElement(ValueDisplay, {
        width: "40%",
        title: "Location",
        value: location
    }), /*#__PURE__*/ _react.default.createElement(ValueDisplay, {
        width: "20%",
        title: "Arrival date",
        value: (0, _getDisplayDate.getDisplayDate)(arrivalDate, 'dd/MM/yy')
    })), diagnosis && /*#__PURE__*/ _react.default.createElement(ValueDisplay, {
        width: "100%",
        title: "Diagnosis",
        value: diagnosis
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(ValueDisplay, {
        width: "100%",
        title: "Notes",
        value: notes || 'N/A'
    }), !!notes && !!createdAt && /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            width: '100%'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: {
            fontSize: 8
        }
    }, `${(0, _getDisplayDate.getDisplayDate)(createdAt, 'dd/MM/yyyy hh:mm a')}${isEdited ? ' (edited)' : ''}`))))), /*#__PURE__*/ _react.default.createElement(_Divider.Divider, null));
};

//# sourceMappingURL=HandoverPatient.js.map