"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findMetroPath = findMetroPath;
exports.getMetroVersion = getMetroVersion;
exports.requireModuleFromMetro = requireModuleFromMetro;
const package_1 = require("@rnx-kit/tools-node/package");
const fs = __importStar(require("fs"));
function resolveFrom(name, startDir) {
    return (0, package_1.findPackageDependencyDir)(name, {
        startDir,
        resolveSymlinks: true,
    });
}
/**
 * Finds the installation path of Metro.
 * @param projectRoot The root of the project; defaults to the current working directory
 * @returns The path to the Metro installation; `undefined` if Metro could not be found
 */
function findMetroPath(projectRoot = process.cwd()) {
    const rnDir = resolveFrom("react-native", projectRoot);
    if (!rnDir) {
        return undefined;
    }
    const pkg = fs.readFileSync(`${rnDir}/package.json`, { encoding: "utf-8" });
    if (pkg.includes("@react-native/community-cli-plugin")) {
        // `metro` dependency was moved to `@react-native/community-cli-plugin` in 0.73
        // https://github.com/facebook/react-native/commit/fdcb94ad1310af6613cfb2a2c3f22f200bfa1c86
        const cliPluginDir = resolveFrom("@react-native/community-cli-plugin", rnDir);
        if (cliPluginDir) {
            return resolveFrom("metro", cliPluginDir);
        }
    }
    const cliDir = resolveFrom("@react-native-community/cli", rnDir);
    if (!cliDir) {
        return undefined;
    }
    const cliMetroDir = resolveFrom("@react-native-community/cli-plugin-metro", cliDir);
    return resolveFrom("metro", cliMetroDir || cliDir);
}
/**
 * Returns Metro version number.
 * @param projectRoot The root of the project; defaults to the current working directory
 * @returns Metro version number; `undefined` if Metro could not be found
 */
function getMetroVersion(projectRoot = process.cwd()) {
    const metroPath = findMetroPath(projectRoot);
    if (!metroPath) {
        return undefined;
    }
    const { version } = (0, package_1.readPackage)(metroPath);
    return version;
}
/**
 * Imports specified module starting from the installation directory of the
 * currently used `metro` version.
 */
function requireModuleFromMetro(moduleName, fromDir = process.cwd()) {
    const startDir = findMetroPath(fromDir);
    if (!startDir) {
        throw new Error("Cannot find module 'metro'");
    }
    const metroDir = "metro/";
    const modulePath = moduleName.startsWith(metroDir)
        ? `${startDir}/${moduleName.substring(metroDir.length)}`
        : resolveFrom(moduleName, startDir);
    if (!modulePath) {
        throw new Error(`Cannot find module '${moduleName}'. This probably means that ` +
            "'@rnx-kit/tools-react-native' is not compatible with the version " +
            "of 'metro' that you are currently using. Please update to the " +
            "latest version and try again. If the issue still persists after the " +
            "update, please file a bug at " +
            "https://github.com/microsoft/rnx-kit/issues.");
    }
    return require(modulePath);
}
//# sourceMappingURL=metro.js.map