"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "buildRoutes", {
    enumerable: true,
    get: function() {
        return buildRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _sync = require("./sync");
const _attachment = require("./attachment");
const _facility = require("./facility");
const _health = require("./health");
const _integrations = require("./integrations");
const _admin = require("./admin");
const _suggestions = require("./suggestions");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const buildRoutes = (ctx)=>{
    const routes = _express.default.Router();
    routes.use('/sync', (0, _sync.buildSyncRoutes)(ctx));
    routes.use('/attachment', _attachment.attachmentRoutes);
    routes.use('/facility', _facility.facilityRoutes);
    routes.use('/health', _health.healthRoutes);
    routes.use('/integration', _integrations.integrationRoutes);
    routes.use('/admin', _admin.adminRoutes);
    routes.use('/suggestions', _suggestions.suggestionsRoutes);
    return routes;
};

//# sourceMappingURL=buildRoutes.js.map