"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "requireClientHeaders", {
    enumerable: true,
    get: function() {
        return requireClientHeaders;
    }
});
const _errors = require("@tamanu/errors");
const requireClientHeaders = (req, res, next)=>{
    if (!req.get('x-tamanu-client')) {
        next(new _errors.MissingCredentialError('Must pass an x-tamanu-client header'));
        return;
    }
    if (!req.get('x-version')) {
        next(new _errors.MissingCredentialError('Must pass an x-version header'));
        return;
    }
    next();
};

//# sourceMappingURL=requireClientHeaders.js.map