"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "defineWebsocketService", {
    enumerable: true,
    get: function() {
        return defineWebsocketService;
    }
});
const _socketio = require("socket.io");
const _postgresadapter = require("@socket.io/postgres-adapter");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
const defineWebsocketService = async (injector)=>{
    const socketServer = new _socketio.Server(injector.httpServer, {
        path: _constants.WS_PATH,
        connectionStateRecovery: {
            skipMiddlewares: true,
            maxDisconnectionDuration: 120000
        }
    });
    const getSocketServer = ()=>socketServer;
    const testMode = process.env.NODE_ENV === 'test';
    let connection;
    try {
        if (!testMode) {
            connection = await injector.sequelize.connectionManager.getConnection();
        }
    } catch (e) {
        _logging.log.error('Error in sequelize connectionManager', e);
    }
    if (connection) {
        socketServer.adapter((0, _postgresadapter.createAdapter)(// just a hack because we can't get the pg.Pool instance from sequelize instance directly so we pass the connection object which is the pg.Pool instance
        {
            query: async (sql, bind)=>{
                const result = await injector.sequelize.query(sql, {
                    bind,
                    type: sql.split(' ')?.[0]
                });
                return {
                    rows: result[0]
                };
            },
            connect: async ()=>{
                return connection;
            }
        }, {
            errorHandler: (e)=>_logging.log.error('Error in postgres adapter:', e)
        }));
    }
    /**
   *
   * @param {string} eventName
   * @param  {...unknown} args
   * @returns
   */ const emit = (eventName, ...args)=>socketServer.emit(eventName, ...args);
    const registerEvent = (eventName, handler)=>{
        socketServer.on('connection', (socket)=>{
            socket.on(eventName, handler);
        });
    };
    return {
        getSocketServer,
        emit,
        registerEvent
    };
};

//# sourceMappingURL=websocketService.js.map