"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CERTIFICATE_NOTIFICATION_STATUSES: function() {
        return CERTIFICATE_NOTIFICATION_STATUSES;
    },
    COVID_19_CLEARANCE_CERTIFICATE: function() {
        return COVID_19_CLEARANCE_CERTIFICATE;
    },
    EUDCC_CERTIFICATE_TYPES: function() {
        return EUDCC_CERTIFICATE_TYPES;
    },
    EUDCC_SCHEMA_VERSION: function() {
        return EUDCC_SCHEMA_VERSION;
    },
    ICAO_DOCUMENT_TYPES: function() {
        return ICAO_DOCUMENT_TYPES;
    },
    INJECTION_SITE_LABELS: function() {
        return INJECTION_SITE_LABELS;
    },
    INJECTION_SITE_VALUES: function() {
        return INJECTION_SITE_VALUES;
    },
    VACCINATION_CERTIFICATE: function() {
        return VACCINATION_CERTIFICATE;
    },
    VACCINE_CATEGORIES: function() {
        return VACCINE_CATEGORIES;
    },
    VACCINE_CATEGORIES_VALUES: function() {
        return VACCINE_CATEGORIES_VALUES;
    },
    VACCINE_CATEGORY_LABELS: function() {
        return VACCINE_CATEGORY_LABELS;
    },
    VACCINE_CATEGORY_OPTIONS: function() {
        return VACCINE_CATEGORY_OPTIONS;
    },
    VACCINE_RECORDING_TYPES: function() {
        return VACCINE_RECORDING_TYPES;
    },
    VACCINE_STATUS: function() {
        return VACCINE_STATUS;
    },
    VACCINE_STATUS_LABELS: function() {
        return VACCINE_STATUS_LABELS;
    },
    X502_OIDS: function() {
        return X502_OIDS;
    }
});
const VACCINE_CATEGORIES = {
    ROUTINE: 'Routine',
    CATCHUP: 'Catchup',
    CAMPAIGN: 'Campaign',
    OTHER: 'Other'
};
const VACCINE_CATEGORY_LABELS = {
    [VACCINE_CATEGORIES.ROUTINE]: 'Routine',
    [VACCINE_CATEGORIES.CATCHUP]: 'Catch-up',
    [VACCINE_CATEGORIES.CAMPAIGN]: 'Campaign',
    [VACCINE_CATEGORIES.OTHER]: 'Other'
};
const VACCINE_CATEGORY_OPTIONS = [
    {
        value: VACCINE_CATEGORIES.ROUTINE,
        label: VACCINE_CATEGORY_LABELS[VACCINE_CATEGORIES.ROUTINE]
    },
    {
        value: VACCINE_CATEGORIES.CATCHUP,
        label: VACCINE_CATEGORY_LABELS[VACCINE_CATEGORIES.CATCHUP]
    },
    {
        value: VACCINE_CATEGORIES.CAMPAIGN,
        label: VACCINE_CATEGORY_LABELS[VACCINE_CATEGORIES.CAMPAIGN]
    },
    {
        value: VACCINE_CATEGORIES.OTHER,
        label: VACCINE_CATEGORY_LABELS[VACCINE_CATEGORIES.OTHER]
    }
];
const VACCINE_CATEGORIES_VALUES = Object.values(VACCINE_CATEGORIES);
const INJECTION_SITE_VALUES = {
    LEFT_ARM: 'left_arm',
    RIGHT_ARM: 'right_arm',
    LEFT_THIGH: 'left_thigh',
    RIGHT_THIGH: 'right_thigh',
    ORAL: 'oral',
    OTHER: 'other'
};
const INJECTION_SITE_LABELS = {
    [INJECTION_SITE_VALUES.LEFT_ARM]: 'Left arm',
    [INJECTION_SITE_VALUES.RIGHT_ARM]: 'Right arm',
    [INJECTION_SITE_VALUES.LEFT_THIGH]: 'Left thigh',
    [INJECTION_SITE_VALUES.RIGHT_THIGH]: 'Right thigh',
    [INJECTION_SITE_VALUES.ORAL]: 'Oral',
    [INJECTION_SITE_VALUES.OTHER]: 'Other'
};
const ICAO_DOCUMENT_TYPES = {
    PROOF_OF_TESTING: {
        DOCTYPE: 'NT',
        JSON: 'icao.test'
    },
    PROOF_OF_VACCINATION: {
        DOCTYPE: 'NV',
        JSON: 'icao.vacc'
    }
};
const COVID_19_CLEARANCE_CERTIFICATE = 'covid_19_clearance';
const VACCINATION_CERTIFICATE = 'vaccination_certificate';
const EUDCC_CERTIFICATE_TYPES = {
    VACCINATION: 'v',
    TEST: 't',
    RECOVERY: 'r'
};
const EUDCC_SCHEMA_VERSION = '1.3.0';
const X502_OIDS = {
    COMMON_NAME: '2.5.4.3',
    COUNTRY_NAME: '2.5.4.6',
    BASIC_CONSTRAINTS: '2.5.29.19',
    KEY_USAGE: '2.5.29.15',
    PRIVATE_KEY_USAGE_PERIOD: '2.5.29.16',
    EXTENDED_KEY_USAGE: '2.5.29.37',
    KEY_IDENTIFIER: '2.5.29.14',
    AUTHORITY_KEY_IDENTIFIER: '2.5.29.35',
    DOCUMENT_TYPE: '2.23.136.1.1.6.2',
    EKU_VDS_NC: '2.23.136.1.1.14.2',
    EKU_EU_DCC_TEST: '1.3.6.1.4.1.1847.2021.1.1',
    EKU_EU_DCC_VACCINATION: '1.3.6.1.4.1.1847.2021.1.2',
    EKU_EU_DCC_RECOVERY: '1.3.6.1.4.1.1847.2021.1.3'
};
const CERTIFICATE_NOTIFICATION_STATUSES = {
    QUEUED: 'Queued',
    PROCESSED: 'Processed',
    ERROR: 'Error',
    IGNORE: 'Ignore'
};
const VACCINE_STATUS = {
    UNKNOWN: 'UNKNOWN',
    GIVEN: 'GIVEN',
    NOT_GIVEN: 'NOT_GIVEN',
    SCHEDULED: 'SCHEDULED',
    MISSED: 'MISSED',
    DUE: 'DUE',
    UPCOMING: 'UPCOMING',
    OVERDUE: 'OVERDUE',
    RECORDED_IN_ERROR: 'RECORDED_IN_ERROR',
    HISTORICAL: 'HISTORICAL'
};
const VACCINE_STATUS_LABELS = {
    [VACCINE_STATUS.UNKNOWN]: 'Unknown',
    [VACCINE_STATUS.GIVEN]: 'Given',
    [VACCINE_STATUS.NOT_GIVEN]: 'Not given',
    [VACCINE_STATUS.SCHEDULED]: 'Scheduled',
    [VACCINE_STATUS.MISSED]: 'Missed',
    [VACCINE_STATUS.DUE]: 'Due',
    [VACCINE_STATUS.UPCOMING]: 'Upcoming',
    [VACCINE_STATUS.OVERDUE]: 'Overdue',
    [VACCINE_STATUS.RECORDED_IN_ERROR]: 'Recorded in error',
    [VACCINE_STATUS.HISTORICAL]: 'Historical'
};
const VACCINE_RECORDING_TYPES = {
    GIVEN: VACCINE_STATUS.GIVEN,
    NOT_GIVEN: VACCINE_STATUS.NOT_GIVEN
};

//# sourceMappingURL=vaccines.js.map