"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
async function up(query) {
    await query.changeColumn('patient_communications', 'type', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: false
    });
    await query.changeColumn('patient_communications', 'channel', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: false
    });
}
async function down(query) {
    await query.changeColumn('patient_communications', 'type', {
        type: _sequelize.Sequelize.ENUM(_constants.PATIENT_COMMUNICATION_TYPES_VALUES),
        allowNull: false
    });
    await query.changeColumn('patient_communications', 'channel', {
        type: _sequelize.Sequelize.ENUM(_constants.PATIENT_COMMUNICATION_CHANNELS_VALUES),
        allowNull: false
    });
}

//# sourceMappingURL=1711683337804-updatePatientCommunicationFields.js.map