"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_additional_data', 'secondary_village_id', {
        type: _sequelize.DataTypes.TEXT,
        references: {
            model: 'reference_data',
            key: 'id'
        },
        allowNull: true
    });
    await query.addIndex('patient_additional_data', [
        'secondary_village_id'
    ]);
}
async function down(query) {
    await query.removeColumn('patient_additional_data', 'secondary_village_id');
}

//# sourceMappingURL=1716950730722-addSecondaryVillageToPatientAdditionalData.js.map