"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('user_login_attempts', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        outcome: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        device_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true,
            references: {
                model: 'devices',
                key: 'id'
            }
        }
    });
    await query.addIndex('user_login_attempts', {
        fields: [
            'user_id',
            'device_id'
        ]
    });
}
async function down(query) {
    await query.dropTable('user_login_attempts');
}

//# sourceMappingURL=1757268197134-createUserLoginAttempts.js.map