import { type DeviceScope } from '@tamanu/constants';
import { Model } from './Model';
import type { ReadSettings } from '@tamanu/settings';
import type { User } from './User';
import type { InitOptions, Models } from '../types/model';
export declare class Device extends Model {
    id: string;
    lastSeenAt: Date;
    registeredById: string;
    scopes: DeviceScope[];
    name?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getQuotaByUserId(userId: string): Promise<number>;
    markSeen(): Promise<void>;
    requiresQuota(): boolean;
    ensureHasScope(scope: DeviceScope): void;
    static ensureRegistration({ settings, user, deviceId, scopes, }: EnsureRegistrationParams): Promise<Device | undefined>;
}
export interface EnsureRegistrationParams {
    settings: ReadSettings;
    user: User;
    deviceId?: string;
    scopes: string[];
}
//# sourceMappingURL=Device.d.ts.map