import { Model } from './Model';
import { Encounter } from './Encounter';
import { ScheduledVaccine } from './ScheduledVaccine';
import { type InitOptions, type Models } from '../types/model';
import type { User } from './User';
export declare class AdministeredVaccine extends Model {
    id: string;
    batch?: string;
    consent?: boolean;
    consentGivenBy?: string;
    status: string;
    reason?: string;
    injectionSite?: string;
    givenBy?: string;
    givenElsewhere?: boolean;
    vaccineBrand?: string;
    vaccineName?: string;
    disease?: string;
    circumstanceIds?: string[];
    date?: string;
    encounterId?: string;
    encounter?: Encounter;
    scheduledVaccineId?: string;
    scheduledVaccine?: ScheduledVaccine;
    recorderId?: string;
    recorder?: User;
    locationId?: string;
    departmentId?: string;
    notGivenReasonId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static lastVaccinationForPatient(patientId: string, vaccineIds?: string[]): Promise<AdministeredVaccine | null>;
}
//# sourceMappingURL=AdministeredVaccine.d.ts.map