"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getAnswers", {
    enumerable: true,
    get: function() {
        return getAnswers;
    }
});
const _sequelize = require("sequelize");
const getAnswers = async (models, where)=>models.SurveyResponseAnswer.findAll({
        where: {
            ...where,
            body: {
                [_sequelize.Op.not]: ''
            }
        },
        include: [
            {
                model: models.SurveyResponse,
                as: 'surveyResponse',
                include: [
                    {
                        model: models.Encounter,
                        as: 'encounter'
                    }
                ]
            }
        ],
        order: [
            [
                {
                    model: models.SurveyResponse,
                    as: 'surveyResponse'
                },
                'end_time',
                'ASC'
            ]
        ]
    });

//# sourceMappingURL=getAnswers.js.map