"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createEncounterSchema: function() {
        return createEncounterSchema;
    },
    updateEncounterSchema: function() {
        return updateEncounterSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const _types = require("@tamanu/shared/schemas/types");
const _dateTime = require("@tamanu/utils/dateTime");
const createEncounterSchema = _zod.z.object({
    // Required fields for encounter creation
    encounterType: _zod.z.enum(_constants.ENCOUNTER_TYPES),
    startDate: _dateTime.datetimeCustomValidation,
    patientId: _types.foreignKey,
    examinerId: _types.foreignKey,
    locationId: _types.foreignKey,
    departmentId: _types.foreignKey,
    // Optional fields
    endDate: _dateTime.datetimeCustomValidation.optional(),
    reasonForEncounter: _types.stringWithMaxLength.optional(),
    deviceId: _types.stringWithMaxLength.optional(),
    plannedLocationStartTime: _dateTime.datetimeCustomValidation.optional(),
    plannedLocationId: _types.foreignKey.optional(),
    patientBillingTypeId: _types.foreignKey.optional(),
    referralSourceId: _types.foreignKey.optional(),
    dietIds: _types.foreignKey.array().optional()
});
const updateEncounterSchema = createEncounterSchema.partial().omit({
    encounterType: true
});

//# sourceMappingURL=createEncounter.schema.js.map