/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('invoices', 'discount_markup_percentage', {
        type: _sequelize.DataTypes.DECIMAL
    });
    await query.addColumn('invoices', 'discount_markup_reason', {
        type: _sequelize.DataTypes.STRING
    });
}
async function down(query) {
    await query.removeColumn('invoices', 'discount_markup_percentage');
    await query.removeColumn('invoices', 'discount_markup_reason');
}

//# sourceMappingURL=1715069649383-addAddDiscountColumnsToInvoice.js.map