"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('medication_administration_records', {
        id: {
            type: _sequelize.DataTypes.STRING,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid'),
            allowNull: false,
            primaryKey: true
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        due_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        recorded_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        recorded_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        prescription_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'prescriptions',
                key: 'id'
            }
        },
        is_auto_generated: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false
        },
        changing_status_reason: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        changing_not_given_info_reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        reason_not_given_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        is_error: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: true
        },
        error_notes: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        is_edited: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('medication_administration_records');
}

//# sourceMappingURL=1741340974971-addMedicationAdministrationRecordTable.js.map