"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION flag_lookup_model_to_rebuild(model_name text) RETURNS void AS $$
    BEGIN
      INSERT INTO local_system_facts (key, value)
      VALUES ('${_constants.FACT_LOOKUP_MODELS_TO_REBUILD}', model_name)
      ON CONFLICT (key) DO UPDATE SET value = 
        CASE 
        WHEN local_system_facts.value IS NULL OR local_system_facts.value = '' THEN
	          -- If the value is null or empty, set it to the model name
          model_name
        WHEN model_name = ANY(string_to_array(local_system_facts.value, ',')) THEN
          -- If the model name is already in the array, do nothing
          local_system_facts.value
        ELSE
          -- If the model name is not in the array, add it
          local_system_facts.value || ',' || model_name
        END;
    END;
    $$ LANGUAGE plpgsql;
  `);
}
async function down(query) {
    await query.sequelize.query(`
    DROP FUNCTION flag_lookup_model_to_rebuild(text);
  `);
}

//# sourceMappingURL=1755227673457-AddLookupModelsToRebuildFact.js.map