import { Model } from './Model';
import type { InitOptions } from '../types/model';
import type { ModelSanitizeArgs } from '../types/sync';
export declare class Attachment extends Model {
    id: string;
    type?: String;
    size?: Number;
    data?: Buffer;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static sanitizeForDatabase({ data, ...restOfValues }: ModelSanitizeArgs<{
        data: string;
        type?: string;
        size?: number;
    }>): {
        data: Buffer<ArrayBuffer>;
        type?: string;
        size?: number;
    };
    static sanitizeForCentralServer(values: ModelSanitizeArgs<{
        data: string;
        type?: string;
        size?: number;
    }>): {
        data: Buffer<ArrayBuffer>;
        type?: string;
        size?: number;
    };
}
//# sourceMappingURL=Attachment.d.ts.map