"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientFacility", {
    enumerable: true,
    get: function() {
        return patientFacility;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _errors = require("@tamanu/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientFacility = _express.default.Router();
patientFacility.post('/$', async (req, res)=>{
    const { syncConnection, models, body } = req;
    const { patientId, facilityId } = body;
    // slightly unusual to check read permissions in a post endpoint, but if you can read patients,
    // you can mark them for sync
    req.checkPermission('read', 'Patient');
    const patient = await models.Patient.findByPk(patientId);
    if (!patient) {
        throw new _errors.NotFoundError();
    }
    // this endpoint functions as a "find or update", avoiding any issues where another device marks
    // the patient for sync, and that copy syncs in after the user is already in the patient page
    const [record] = await models.PatientFacility.findOrCreate({
        where: {
            facilityId,
            patientId
        }
    });
    // trigger a sync to immediately start pulling data for this patient
    await syncConnection.runSync({
        urgent: true,
        type: 'patientMarkedForSync',
        patientId: patient.id,
        patientDisplayId: patient.displayId
    });
    res.send(record);
});

//# sourceMappingURL=patientFacility.js.map