import { times } from 'lodash';
import { REPEAT_FREQUENCY } from '@tamanu/constants';
import { randomRecordId } from '@tamanu/database/demoData/utilities';
import { fake, chance } from '../../fake/index.js';
export const createAppointment = async ({ models, locationGroupId, patientId, clinicianId })=>{
    const { Appointment } = models;
    await Appointment.create(fake(Appointment, {
        patientId: patientId || await randomRecordId(models, 'Patient'),
        clinicianId: clinicianId || await randomRecordId(models, 'User'),
        locationGroupId: locationGroupId || await randomRecordId(models, 'LocationGroup')
    }));
};
export const createRepeatingAppointment = async ({ models, limit, locationGroupId, patientId, clinicianId, apptCount = chance.integer({
    min: 1,
    max: 50
}) })=>{
    const { AppointmentSchedule, Appointment } = models;
    const appointmentSchedule = await AppointmentSchedule.create(fake(AppointmentSchedule, {
        frequency: REPEAT_FREQUENCY.WEEKLY,
        locationGroupId: locationGroupId ?? await randomRecordId(models, 'LocationGroup')
    }));
    await Promise.all(times(apptCount, ()=>limit(async ()=>{
            await Appointment.create(fake(Appointment, {
                patientId: patientId ?? await randomRecordId(models, 'Patient'),
                clinicianId: clinicianId ?? await randomRecordId(models, 'User'),
                locationGroupId: locationGroupId ?? await randomRecordId(models, 'LocationGroup'),
                scheduleId: appointmentSchedule.id
            }));
        })));
};

//# sourceMappingURL=appointment.js.map