"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AdministeredVaccineExporter", {
    enumerable: true,
    get: function() {
        return AdministeredVaccineExporter;
    }
});
const _dateTime = require("@tamanu/utils/dateTime");
const _DefaultDataExporter = require("./DefaultDataExporter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let AdministeredVaccineExporter = class AdministeredVaccineExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const administeredVaccines = await this.models.AdministeredVaccine.findAll({
            include: [
                {
                    model: this.models.Encounter,
                    as: 'encounter',
                    attributes: [
                        'locationId',
                        'departmentId',
                        'examinerId',
                        'patientId'
                    ]
                }
            ]
        });
        const data = administeredVaccines.map(({ dataValues: vaccine })=>{
            const { encounter, ...otherProps } = vaccine;
            return {
                ...otherProps,
                ...encounter.dataValues
            };
        });
        return data;
    }
    getHeadersFromData(data) {
        return Object.keys(data[0]);
    }
    constructor(...args){
        super(...args), _define_property(this, "customCellFormatter", {
            date: (value)=>{
                return (0, _dateTime.parseDate)(value);
            },
            consent: (value)=>{
                return value ? 'y' : 'n';
            }
        });
    }
};

//# sourceMappingURL=AdministeredVaccineExporter.js.map