"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "changePassword", {
    enumerable: true,
    get: function() {
        return changePassword;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _logging = require("@tamanu/shared/services/logging");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const changePassword = _express.default.Router();
const schema = _yup.object({
    email: _yup.string().email('Must enter a valid email').required(),
    newPassword: _yup.string().min(5, 'Must be at least 5 characters').required(),
    token: _yup.string().required()
});
changePassword.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store, body } = req;
    await schema.validate(body);
    await doChangePassword(store, body);
    res.send({
        ok: 'ok'
    });
}));
changePassword.post('/validate-reset-code', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store, body } = req;
    await validateResetCode(store, body);
    res.send({
        ok: 'ok'
    });
}));
const doChangePassword = async (store, { email, newPassword, token })=>{
    const { models } = store;
    const user = await models.User.getForAuthByEmail(email);
    const userId = user ? user.id : 'thwart-timing-attack';
    const oneTimeLogin = await models.OneTimeLogin.findOne({
        where: {
            userId,
            token
        }
    });
    if (!oneTimeLogin) {
        _logging.log.info(`One time login with email ${email} and token ${token} not found`);
        throw new _yup.ValidationError(`User or token not found`);
    }
    if (oneTimeLogin.usedAt !== null) {
        throw new _yup.ValidationError(`Token has been used`, token, 'token');
    }
    if (oneTimeLogin.isExpired()) {
        throw new _yup.ValidationError(`Token has expired`, token, 'token');
    }
    await models.User.sequelize.transaction(async ()=>{
        await models.User.update({
            password: newPassword
        }, {
            where: {
                id: user.id
            }
        });
        await models.OneTimeLogin.update({
            usedAt: Date.now()
        }, {
            where: {
                id: oneTimeLogin.id
            }
        });
    });
};
const validateResetCode = async (store, { email, token })=>{
    const { models } = store;
    const user = await models.User.getForAuthByEmail(email);
    const userId = user ? user.id : 'thwart-timing-attack';
    const oneTimeLogin = await models.OneTimeLogin.findOne({
        where: {
            userId,
            token
        }
    });
    if (!oneTimeLogin) {
        _logging.log.info('oneTimeLogin.tokenNotFound', {
            token
        });
        throw new _yup.ValidationError('Token not found for this user');
    }
};

//# sourceMappingURL=changePassword.js.map