"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('patient_contacts', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        method: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        connection_details: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        deletion_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        patient_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        relationship_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        }
    });
}
async function down(query) {
    await query.dropTable('patient_contacts');
}

//# sourceMappingURL=1705975889388-addPatientContactTable.js.map