/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('invoice_items', 'product_discountable', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.sequelize.query(`
    UPDATE invoice_items
    SET product_name = ''
    WHERE product_name IS NULL
  `);
    await query.changeColumn('invoice_items', 'product_name', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        defaultValue: ''
    });
    await query.sequelize.query(`
    UPDATE invoice_items
    SET product_price = 0
    WHERE product_price IS NULL
  `);
    await query.changeColumn('invoice_items', 'product_price', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: false,
        defaultValue: 0
    });
    await query.sequelize.query(`
    UPDATE invoice_items
    SET product_code = ''
    WHERE product_code IS NULL
  `);
    await query.changeColumn('invoice_items', 'product_code', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        defaultValue: ''
    });
}
async function down(query) {
    await query.removeColumn('invoice_items', 'product_discountable');
    await query.changeColumn('invoice_items', 'product_name', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.changeColumn('invoice_items', 'product_price', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: true
    });
    await query.changeColumn('invoice_items', 'product_code', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
}

//# sourceMappingURL=1719478189570-updateInvoiceItemTable.js.map