/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('tasks', 'deleted_reason_for_sync_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'reference_data',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('tasks', 'deleted_reason_for_sync_id');
}

//# sourceMappingURL=1728280018943-addDeletedReasonForSyncIdToTaskTable.js.map