"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // we only need pgcrypto for postgres <13
    const rows = await query.sequelize.query('SELECT setting FROM pg_settings WHERE name = $name LIMIT 1', {
        type: _sequelize.QueryTypes.SELECT,
        bind: {
            name: 'server_version_num'
        }
    });
    if ((rows?.[0]?.setting ?? 0) < 130000) {
        await query.sequelize.query('CREATE EXTENSION IF NOT EXISTS pgcrypto');
    }
}
async function down(query) {
    await query.sequelize.query('DROP EXTENSION IF EXISTS pgcrypto');
}

//# sourceMappingURL=1739168538058-pgcryptoExtension.js.map