"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserRecentlyViewedPatient", {
    enumerable: true,
    get: function() {
        return UserRecentlyViewedPatient;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let UserRecentlyViewedPatient = class UserRecentlyViewedPatient extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static async create(data) {
        return super.upsert(data, {
            conflictFields: [
                'user_id',
                'patient_id'
            ]
        });
    }
};

//# sourceMappingURL=UserRecentlyViewedPatient.js.map