import { DataTypes } from 'sequelize';
import { isBefore, parseISO } from 'date-fns';
import { SYNC_DIRECTIONS, PORTAL_ONE_TIME_TOKEN_TYPES, PORTAL_ONE_TIME_TOKEN_TYPE_VALUES } from '@tamanu/constants';
import { Model } from './Model';
import { dateTimeType } from '../types/model';
export class PortalOneTimeToken extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            type: {
                type: DataTypes.ENUM(...PORTAL_ONE_TIME_TOKEN_TYPE_VALUES),
                defaultValue: PORTAL_ONE_TIME_TOKEN_TYPES.LOGIN,
                allowNull: false
            },
            token: {
                type: DataTypes.STRING,
                allowNull: false
            },
            expiresAt: dateTimeType('expiresAt', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    isExpired() {
        return isBefore(parseISO(this.expiresAt), new Date());
    }
    static initRelations(models) {
        this.belongsTo(models.PortalUser, {
            foreignKey: {
                name: 'portalUserId',
                allowNull: false
            },
            as: 'portalUser'
        });
    }
}

//# sourceMappingURL=PortalOneTimeToken.js.map