"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createMedication", {
    enumerable: true,
    get: function() {
        return createMedication;
    }
});
const _index = require("../../fake/index.js");
const createMedication = async ({ models: { Prescription, EncounterPrescription, PatientOngoingPrescription, EncounterPausePrescription, EncounterPausePrescriptionHistory }, encounterId, patientId, referenceDataId })=>{
    const prescription = await Prescription.create((0, _index.fake)(Prescription, {
        medicationId: referenceDataId
    }));
    const encounterPrescription = await EncounterPrescription.create((0, _index.fake)(EncounterPrescription, {
        encounterId,
        prescriptionId: prescription.id
    }));
    await PatientOngoingPrescription.create((0, _index.fake)(PatientOngoingPrescription, {
        patientId: patientId,
        prescriptionId: prescription.id
    }));
    await EncounterPausePrescription.create((0, _index.fake)(EncounterPausePrescription, {
        encounterPrescriptionId: encounterPrescription.id
    }));
    await EncounterPausePrescriptionHistory.create((0, _index.fake)(EncounterPausePrescriptionHistory, {
        encounterPrescriptionId: encounterPrescription.id
    }));
};

//# sourceMappingURL=medication.js.map