"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentState = getCurrentState;
exports.getSavedState = getSavedState;
exports.invalidateState = invalidateState;
exports.loadConfigFromCache = loadConfigFromCache;
exports.saveConfigToCache = saveConfigToCache;
const path_1 = require("@rnx-kit/tools-node/path");
const crypto = __importStar(require("crypto"));
const nodefs = __importStar(require("fs"));
const path = __importStar(require("path"));
const HASH_ALGO = "sha256";
const UTF8 = { encoding: "utf-8" };
function ensureDir(p, /** @internal */ fs = nodefs) {
    fs.mkdirSync(p, { recursive: true, mode: 0o755 });
}
function makeCachePath(projectRoot, filename) {
    return path.join(projectRoot, "node_modules", ".cache", "rnx-kit", filename);
}
function cacheStatePath(projectRoot) {
    return makeCachePath(projectRoot, `config.${HASH_ALGO}`);
}
function configCachePath(projectRoot) {
    return makeCachePath(projectRoot, "config.json");
}
function updateHash(hash, files, projectRoot, mode, 
/** @internal */ fs = nodefs) {
    const options = { startDir: projectRoot };
    for (const file of files) {
        const p = (0, path_1.findUp)(file, options);
        if (p) {
            hash.update(fs.readFileSync(p));
            if (mode === "first-only") {
                break;
            }
        }
    }
}
function getCurrentState(projectRoot) {
    const sha2 = crypto.createHash(HASH_ALGO);
    const configFiles = ["package.json", "react-native.config.js"];
    updateHash(sha2, configFiles, projectRoot, "all");
    const lockfiles = [
        "yarn.lock",
        "package-lock.json",
        "pnpm-lock.yaml",
        "bun.lockb",
    ];
    updateHash(sha2, lockfiles, projectRoot, "first-only");
    return sha2.digest("hex");
}
function getSavedState(projectRoot, 
/** @internal */ fs = nodefs) {
    const stateFile = cacheStatePath(projectRoot);
    return fs.existsSync(stateFile) && fs.readFileSync(stateFile, UTF8);
}
function invalidateState(projectRoot = process.cwd(), 
/** @internal */ fs = nodefs) {
    fs.rmSync(configCachePath(projectRoot));
    fs.rmSync(cacheStatePath(projectRoot));
}
function loadConfigFromCache(projectRoot, 
/** @internal */ fs = nodefs) {
    const cacheFile = configCachePath(projectRoot);
    if (!fs.existsSync(cacheFile)) {
        return null;
    }
    const config = fs.readFileSync(cacheFile, UTF8);
    return JSON.parse(config);
}
function saveConfigToCache(projectRoot, state, config, 
/** @internal */ fs = nodefs) {
    const data = JSON.stringify(config);
    const configPath = configCachePath(projectRoot);
    ensureDir(path.dirname(configPath), fs);
    fs.writeFileSync(configPath, data, UTF8);
    fs.writeFileSync(cacheStatePath(projectRoot), state, UTF8);
}
//# sourceMappingURL=cache.js.map