"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getSyncSnapshotRecordIds", {
    enumerable: true,
    get: function() {
        return getSyncSnapshotRecordIds;
    }
});
const _sequelize = require("sequelize");
const _manageSnapshotTable = require("./manageSnapshotTable");
const getSyncSnapshotRecordIds = async (sequelize, sessionId, direction, recordType, limit, fromId = '00000000-0000-0000-0000-000000000000')=>{
    const tableName = (0, _manageSnapshotTable.getSnapshotTableName)(sessionId);
    const rows = await sequelize.query(`
        SELECT record_id FROM ${tableName}
        WHERE record_id > :fromId -- record_id can be used as offset since it should be unique among a direction (ie: INCOMING or OUTGOING)
        AND direction = :direction
        ${recordType ? 'AND record_type = :recordType' : ''}
        ORDER BY record_id ASC
        LIMIT :limit;
    `, {
        replacements: {
            recordType,
            direction,
            limit,
            fromId
        },
        type: _sequelize.QueryTypes.SELECT,
        raw: true
    });
    return rows.map((r)=>r.record_id);
};

//# sourceMappingURL=getSyncSnapshotRecordIds.js.map