"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    readOnlyTransaction: function() {
        return readOnlyTransaction;
    },
    repeatableReadTransaction: function() {
        return repeatableReadTransaction;
    }
});
const _sequelize = require("sequelize");
const wrapTransaction = async (sequelize, options = {}, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>{
    return sequelize.transaction(options, async (transaction)=>{
        // transaction does not actually start until the first query is executed,
        // so just select 1 here to start the transaction as soon as possible
        await sequelize.query('SELECT 1;', {
            transaction
        });
        return executeWithinTransaction(transaction);
    });
};
const repeatableReadTransaction = async (sequelize, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>wrapTransaction(sequelize, {
        isolationLevel: _sequelize.Transaction.ISOLATION_LEVELS.REPEATABLE_READ
    }, executeWithinTransaction);
const readOnlyTransaction = async (sequelize, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>{
    return wrapTransaction(sequelize, {}, async (transaction)=>{
        // Set the transaction to read-only mode
        await sequelize.query('SET TRANSACTION READ ONLY;', {
            transaction
        });
        return executeWithinTransaction(transaction);
    });
};

//# sourceMappingURL=transactions.js.map